@extends('admin.layout.layout')
@section('content')

  <div class="content-wrapper">

    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h3>Assign Volunteer Management</h3>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Assign Volunteer</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

	 <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">

            <div class="card">
              <div class="card-header">
                <a href="{{url('assign-volunteer')}}"><h3 class="card-title"><button type="button" class="btn btn-block bg-gradient-primary">Assign Volunteer</button></h3></a>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>S.No</th>
                    <th>User Name</th>
                    <th>Volunteer Name</th>
                    <th>Date</th>
                    <th>Action</th>
                  </tr>
                  </thead>
                  <tbody>
				  @foreach($user as $key => $userDetails)
                  <tr>
                    <td>{{$key + 1}}</td>
                    <td>{{$userDetails->name}}</td>
                    <td>{{$userDetails->volunteers_name}}</td>
                    <td>{{$userDetails->created_at}}</td>
					<td>
                        <!--a type="button" class="btn btn-primary" href="edit-assign-volunteer/{{$userDetails->id}}">Edit</a>&nbsp;&nbsp;--><a type="button" class="btn btn-primary" href="delete-assign-volunteer/{{$userDetails->id}}">Delete</a>
					</td>
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                   <tr>
                    <th>S.No</th>
                    <th>User Name</th>
                    <th>Volunteer Name</th>
                    <th>Date</th>
                    <th>Action</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>

            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>


   </div>
  @endsection
