<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Appointment extends Model
{
    protected $guarded = [];

    protected $appends = ['formatted_appointment_date'];

    protected function appointmentStartTime(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => substr($value,0, 5),
        );
    }

    protected function appointmentEndTime(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => substr($value,0, 5),
        );
    }

    public function getFormattedAppointmentDateAttribute(): string
    {
        $formattedDate = Carbon::parse($this->appointment_date)->format('d-M-Y');

        return $formattedDate;
    }

    public function sector()
    {
        return $this->belongsTo(Sector::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function appointmentTimelines()
    {
        return $this->hasMany(AppointmentTimeline::class);
    }
}
