<?php

namespace App\Http\Resources;

use App\Models\Appointment;
use App\Models\Sector;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DashboardStatsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'total_appointments' => Appointment::count(),
            'today_appointments' => Appointment::whereDate('appointment_date', Carbon::now())->count(),
            'past_appointments' => Appointment::whereDate('appointment_date', '<', Carbon::now())->count(),
            'upcoming_appointments' => Appointment::whereDate('appointment_date', '>', Carbon::now())->count(),
            'total_sectors' => Sector::count(),
            'total_users' => User::where('user_type_id', 3)->count(),
            'total_volunteers' => User::where('user_type_id', 4)->count()
        ];
    }
}
